CREATE TABLE [dbo].[MOVEMENT_EVN]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[WARD_UID] [uniqueidentifier] NULL,
[BED_UID] [uniqueidentifier] NULL,
[OLD_WARD_UID] [uniqueidentifier] NULL,
[OLD_BED_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[MOVEMENT_DATE] [datetime] NULL,
[ENTERED_BY_UID] [uniqueidentifier] NULL,
[ADMISSION_ID] [int] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__MOVEMENT____ssis__5D16C24D] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
) ON [PRIMARY]

GO

create trigger [dbo].[MOVEMENT_EVN_tgg_ssis_delete] on dbo.MOVEMENT_EVN after delete as begin  delete [dbo].[MOVEMENT_EVN_ssisdel] from [deleted] _xyz where [dbo].[MOVEMENT_EVN_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[MOVEMENT_EVN_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO

create trigger [dbo].[MOVEMENT_EVN_tgg_ssis_insert] on dbo.MOVEMENT_EVN after insert as begin delete [dbo].[MOVEMENT_EVN_ssisdel]  from [inserted] _xyz where [dbo].[MOVEMENT_EVN_ssisdel].[ID]=[_xyz].[ID] end
GO


CREATE TRIGGER [dbo].[utg_Movement_Evn_AfterDelete] 
   ON  [dbo].[MOVEMENT_EVN] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Movement_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END

GO
CREATE TRIGGER [dbo].[utg_Movement_Evn_AfterInsert] 
   ON  [dbo].[MOVEMENT_EVN] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Movement_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END

GO
CREATE TRIGGER [dbo].[utg_Movement_Evn_AfterUpdate] 
   ON  [dbo].[MOVEMENT_EVN] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Movement_Evn_H]
			    (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE,WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
END
GO
CREATE TRIGGER [dbo].[utg_Movement_Evn_InsteadOfInsert] 
   ON  [dbo].[MOVEMENT_EVN]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Movement_Evn]
			   (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;	    	 
	ELSE
		INSERT INTO [dbo].[Movement_Evn]
			    (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_WARD_UID, OLD_BED_UID, VISTA_SITE_UID, TYPE_OF_MOVEMENT_ID, MOVEMENT_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp
			  FROM inserted;
	
END
GO
CREATE TRIGGER [dbo].[utg_Movement_Evn_InsteadOfUpdate] 
   ON  [dbo].[MOVEMENT_EVN] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Movement_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID,
			OLD_WARD_UID = inserted.OLD_WARD_UID,
			OLD_BED_UID = inserted.OLD_BED_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			MOVEMENT_DATE = inserted.MOVEMENT_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Movement_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Movement_Evn].id;
	 
	 ELSE
	    UPDATE [dbo].[Movement_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE, 
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID,
			OLD_WARD_UID = inserted.OLD_WARD_UID,
			OLD_BED_UID = inserted.OLD_BED_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			MOVEMENT_DATE = inserted.MOVEMENT_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[Movement_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Movement_Evn].id;
END
GO

--Constraints
ALTER TABLE [dbo].[MOVEMENT_EVN] ADD CONSTRAINT [PK_MOVEMENT_EVN] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[MOVEMENT_EVN] ADD CONSTRAINT [FK_MOVEMENT_EVN_CONCEPT_TYPE_OF_MOVEMENT] FOREIGN KEY ([TYPE_OF_MOVEMENT_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[MOVEMENT_EVN] ADD CONSTRAINT [DF_MOVEMENT_EVN_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO
ALTER TABLE [dbo].[MOVEMENT_EVN] ADD CONSTRAINT [FK_MOVEMENT_EVN_ADMISSION_EVN_ADMISSION] FOREIGN KEY([ADMISSION_ID]) REFERENCES [dbo].[ADMISSION_EVN] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[MOVEMENT_EVN] ([_ssis_timestamp]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_OLD_BED] ON [dbo].[MOVEMENT_EVN] 
(
	[OLD_BED_UID] ASC
)
INCLUDE ([MOVEMENT_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_UID_MOVEMENT_DATE] ON [dbo].[MOVEMENT_EVN] 
(
	[BED_UID] ASC
)
INCLUDE ([MOVEMENT_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_ADMISSION_ID_IEN] ON [dbo].[MOVEMENT_EVN] 
([ADMISSION_ID] ASC, [IEN] ASC)
INCLUDE ( [BED_UID],[MOVEMENT_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_MOVEMENT_ADMISSION] ON [dbo].[MOVEMENT_EVN] 
(
	[ADMISSION_ID] ASC
)
INCLUDE ( [IEN],
[BED_UID],
[MOVEMENT_DATE],
[DOMAIN_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID] ON [dbo].[MOVEMENT_EVN] 
(
	 [VISTA_SITE_UID] ASC, [MOVEMENT_DATE] ASC

)
INCLUDE ( [ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID], [ADMISSION_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_BED_UID] ON [dbo].[MOVEMENT_EVN] 
([BED_UID], [VISTA_SITE_UID],[MOVEMENT_DATE])
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Movement event act(used to import VistA transfers data).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the movement event act and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The bed id where the patient was moved.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the person who made the movement.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date when the movement was made.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'ENTERED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the type of movement(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ward id where the patient was moved.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of discharges.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of movement.', 'SCHEMA', N'dbo', 'TABLE', N'MOVEMENT_EVN', 'COLUMN', N'MOVEMENT_DATE'
GO